/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.formpage.internal;

import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.formpage.FormPageContributionGroup;
import com.jrockit.mc.ui.formpage.IFormPageSelectorPart;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ButtonToolbarSelector
implements IFormPageSelectorPart {
    private static final int VERTICAL_PAD = 30;
    private static final int HORIZONTAL_TOP = 2;
    private final Composite m_container;
    private List<FormPageContributionGroup> m_topLevelGroups;
    private FormPageContributionGroup m_activeGroup;
    private ToolBar m_toolbar;
    private Point m_toolbarLargeSize;
    private final FormToolkit m_toolkit;
    private boolean m_large = true;
    private final Runnable m_listener;
    private final boolean m_horizontal;
    private boolean m_visible;

    ButtonToolbarSelector(boolean horizontal, FormToolkit toolkit, Composite parent, Runnable listener) {
        this.m_horizontal = horizontal;
        this.m_listener = listener;
        this.m_container = toolkit.createComposite(parent);
        this.m_toolkit = toolkit;
        this.m_toolbar = ButtonToolbarSelector.createToolbar(this.m_horizontal, this.m_container, this.m_toolkit);
        this.m_container.setBackground(toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG"));
        this.m_container.setLayout((Layout)this.createLayout());
    }

    private void hookResizeListener() {
        this.m_container.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                boolean large = ButtonToolbarSelector.this.isLarge();
                if (large != ButtonToolbarSelector.this.m_large) {
                    ButtonToolbarSelector.this.m_toolbar.dispose();
                    ButtonToolbarSelector.this.m_large = large;
                    ButtonToolbarSelector.this.m_toolbar = ButtonToolbarSelector.createToolbar(ButtonToolbarSelector.this.m_horizontal, ButtonToolbarSelector.this.m_container, ButtonToolbarSelector.this.m_toolkit);
                    ButtonToolbarSelector.this.addToolbarButtons();
                }
            }
        });
    }

    private boolean isLarge() {
        Rectangle containerArea = this.m_container.getClientArea();
        if (this.m_horizontal) {
            return this.m_toolbarLargeSize.x < containerArea.width - 2;
        }
        return this.m_toolbarLargeSize.y + 25 + 60 < containerArea.height;
    }

    private static ToolBar createToolbar(boolean horizontal, Composite parent, FormToolkit toolkit) {
        ToolBar tb = new ToolBar(parent, 0x800400 | (horizontal ? 256 : 512));
        tb.setBackground(toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG"));
        tb.setLayoutData((Object)ButtonToolbarSelector.createGridData(horizontal));
        return tb;
    }

    private void addToolbarButtons() {
        for (final FormPageContributionGroup group : this.m_topLevelGroups) {
            ToolItem toolItem = new ToolItem(this.m_toolbar, 16);
            toolItem.setImage(this.getIconForContribution(group));
            String label = group.getLabel();
            if (label.length() > 16) {
                label = String.valueOf(label.substring(0, 13)) + "...";
            } else if (label.length() < 9) {
                String padding = "     ".substring((label.length() + 1) / 2);
                label = String.valueOf(padding) + label + padding;
            }
            toolItem.setText(label);
            if (this.m_activeGroup == group) {
                toolItem.setSelection(true);
            }
            toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ButtonToolbarSelector.this.activate(group);
                }
            });
        }
    }

    private static GridData createGridData(boolean horizontal) {
        GridData gd = new GridData(4, 4, horizontal, !horizontal);
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        gd.minimumWidth = horizontal ? 512 : 72;
        return gd;
    }

    private GridLayout createLayout() {
        GridLayout layout = new GridLayout();
        layout.marginLeft = this.m_horizontal ? 2 : 0;
        layout.marginRight = 0;
        layout.horizontalSpacing = 1;
        layout.marginTop = !this.m_horizontal ? 30 : 2;
        layout.marginBottom = !this.m_horizontal ? 30 : 2;
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = this.m_horizontal ? 100 : 1;
        return layout;
    }

    protected Image getIconForContribution(FormPageContributionGroup groupItem) {
        Image image;
        Image image2 = image = this.m_large ? groupItem.getLargeIcon() : groupItem.getIcon();
        if (image == null) {
            return UIPlugin.getDefault().getImage("error_obj.gif");
        }
        return image;
    }

    @Override
    public void activate(FormPageContributionGroup group) {
        if (group != this.m_activeGroup && this.m_container != null && !this.m_container.isDisposed()) {
            this.m_activeGroup = group;
            this.m_listener.run();
        }
    }

    @Override
    public FormPageContributionGroup getActive() {
        Assert.isNotNull((Object)this.m_activeGroup, (String)"Cannot getActive() before init");
        return this.m_activeGroup;
    }

    @Override
    public void init(List<FormPageContributionGroup> groups) {
        this.m_topLevelGroups = groups;
        this.m_activeGroup = this.m_topLevelGroups.size() > 0 ? this.m_topLevelGroups.get(0) : null;
        this.setVisible(this.m_topLevelGroups.size() > 1);
        if (this.m_visible) {
            this.addToolbarButtons();
            this.m_toolbarLargeSize = this.m_toolbar.computeSize(-1, -1);
            this.hookResizeListener();
        }
    }

    @Override
    public List<FormPageContributionGroup> getGroups() {
        return this.m_topLevelGroups;
    }

    private void setVisible(boolean visible) {
        GridData gd = new GridData(4, 4, this.m_horizontal, !this.m_horizontal);
        gd.exclude = !visible;
        this.m_container.setLayoutData((Object)gd);
        if (!visible) {
            this.m_container.setSize(0, 0);
        }
        this.m_visible = visible;
    }

    @Override
    public boolean tryFocus() {
        if (this.m_visible) {
            this.m_container.setFocus();
        }
        return this.m_visible;
    }
}

