/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu.marking;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapper;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;

public class MarkingEngine {
    private static String INVALID_MID = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.cpu.Bundle").getString("MSG_INVALID_METHODID");
    private static Logger LOGGER = Logger.getLogger(MarkingEngine.class.getName());
    private static MarkingEngine instance;
    private final Object markGuard = new Object();
    private final MarkMapper mapper;
    private MarkMapping[] marks;
    private Set observers = new HashSet();

    private MarkingEngine() {
        this.mapper = new MarkMapper();
    }

    public static synchronized MarkingEngine getDefault() {
        if (instance == null) {
            instance = new MarkingEngine();
        }
        return instance;
    }

    public synchronized void configure(MarkMapping[] markMappingArray, Collection collection) {
        this.setMarks(markMappingArray != null ? markMappingArray : Marker.DEFAULT.getMappings());
        this.observers.clear();
        this.observers.add(this.mapper);
        this.observers.addAll(collection);
    }

    public synchronized void deconfigure() {
        this.setMarks(Marker.DEFAULT.getMappings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientUtils.SourceCodeSelection[] getMarkerMethods() {
        Object object = this.markGuard;
        synchronized (object) {
            if (this.marks == null) {
                return new ClientUtils.SourceCodeSelection[0];
            }
            ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = new ClientUtils.SourceCodeSelection[this.marks.length];
            for (int i = 0; i < this.marks.length; ++i) {
                sourceCodeSelectionArray[i] = this.marks[i].markMask;
            }
            return sourceCodeSelectionArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNMarks() {
        Object object = this.markGuard;
        synchronized (object) {
            return this.marks != null ? this.marks.length : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mark markMethod(int n, ProfilingSessionStatus profilingSessionStatus) {
        MarkMapper markMapper = this.mapper;
        synchronized (markMapper) {
            return this.mapper.getMark(n, profilingSessionStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Mark mark(int n, ProfilingSessionStatus profilingSessionStatus) {
        ClientUtils.SourceCodeSelection sourceCodeSelection = null;
        Object object = this.markGuard;
        synchronized (object) {
            Object object2;
            if (this.marks == null || this.marks.length == 0 || profilingSessionStatus == null) {
                return Mark.DEFAULT;
            }
            profilingSessionStatus.beginTrans(false);
            try {
                object2 = profilingSessionStatus.getInstrMethodClasses();
                String[] stringArray = profilingSessionStatus.getInstrMethodNames();
                String[] stringArray2 = profilingSessionStatus.getInstrMethodSignatures();
                if (stringArray.length <= n || ((String[])object2).length <= n || stringArray2.length <= n) {
                    int n2 = Math.min(Math.min(stringArray.length, ((String[])object2).length), stringArray2.length);
                    LOGGER.log(Level.WARNING, INVALID_MID, new Object[]{n, n2});
                } else {
                    sourceCodeSelection = new ClientUtils.SourceCodeSelection(object2[n], stringArray[n], stringArray2[n]);
                }
            }
            finally {
                profilingSessionStatus.endTrans();
            }
            if (sourceCodeSelection != null) {
                object2 = sourceCodeSelection.toFlattened();
                for (int i = 0; i < this.marks.length; ++i) {
                    if (!((String)object2).startsWith(this.marks[i].markSig)) continue;
                    return this.marks[i].mark;
                }
            }
            return Mark.DEFAULT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMarks(MarkMapping[] markMappingArray) {
        boolean bl = false;
        Object object = this.markGuard;
        synchronized (object) {
            bl = !Arrays.equals(this.marks, markMappingArray);
            this.marks = markMappingArray;
        }
        if (bl) {
            this.fireStateChanged();
        }
    }

    private void fireStateChanged() {
        Iterator iterator = this.observers.iterator();
        while (iterator.hasNext()) {
            ((StateObserver)iterator.next()).stateChanged(this);
        }
    }

    public static interface StateObserver {
        public void stateChanged(MarkingEngine var1);
    }
}

