/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.util.ArrayList;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.ClassManager;
import org.netbeans.lib.profiler.instrumentation.ClassRewriter;
import org.netbeans.lib.profiler.instrumentation.DynamicConstantPoolExtension;
import org.netbeans.lib.profiler.instrumentation.SingleMethodScaner;

public abstract class MemoryProfMethodInstrumentor
extends ClassManager {
    protected ArrayList instrClasses = new ArrayList();
    MethodScanerForNewOpcodes msfno;
    protected String[] instantiatableClasses;
    protected int injType;
    protected int instrClassId;
    protected int nInstantiatableClasses;
    protected int nInstrClasses;
    protected int nInstrMethods;

    public MemoryProfMethodInstrumentor(ProfilingSessionStatus profilingSessionStatus, int n) {
        super(profilingSessionStatus);
        this.status = profilingSessionStatus;
        this.instantiatableClasses = new String[100];
        this.injType = n;
        this.msfno = new MethodScanerForNewOpcodes();
    }

    public Object[] getInitialMethodsToInstrument(String[] stringArray, int[] nArray, byte[][] byArray) {
        MemoryProfMethodInstrumentor.resetLoadedClassData();
        this.initInstrumentationPackData();
        this.instrClassId = 0;
        MemoryProfMethodInstrumentor.storeClassFileBytesForCustomLoaderClasses(stringArray, nArray, byArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("java.lang.Object")) continue;
            this.findAndMarkMethodsToInstrumentInClass(stringArray[i], nArray[i]);
        }
        return this.createInstrumentedMethodPack();
    }

    public String[] getInstantiatableClasses() {
        return this.instantiatableClasses;
    }

    public Object[] getMethodsToInstrumentUponClassLoad(String string, int n) {
        this.initInstrumentationPackData();
        this.findAndMarkMethodsToInstrumentInClass(string, n);
        return this.createInstrumentedMethodPack();
    }

    public int getNInstantiatableClasses() {
        return this.nInstantiatableClasses;
    }

    protected void findAndMarkMethodsToInstrumentInClass(String string, int n) {
        DynamicClassInfo dynamicClassInfo = MemoryProfMethodInstrumentor.javaClassForName(string, n);
        if (dynamicClassInfo == null) {
            return;
        }
        if (!dynamicClassInfo.isLoaded()) {
            dynamicClassInfo.setLoaded(true);
            if (dynamicClassInfo.getInstrClassId() == -1 && !dynamicClassInfo.isInterface()) {
                dynamicClassInfo.setInstrClassId(this.getNextClassId(dynamicClassInfo.getName()));
            }
            String[] stringArray = dynamicClassInfo.getMethodNames();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (dynamicClassInfo.isMethodNative(i) || dynamicClassInfo.isMethodAbstract(i)) {
                    dynamicClassInfo.setMethodUnscannable(i);
                    continue;
                }
                if (!this.methodNeedsInstrumentation(dynamicClassInfo, i)) continue;
                ++this.nInstrMethods;
                dynamicClassInfo.setMethodInstrumented(i);
                bl = true;
            }
            if (bl) {
                ++this.nInstrClasses;
                this.instrClasses.add(dynamicClassInfo);
            }
        }
    }

    protected void initInstrumentationPackData() {
        this.instrClasses.clear();
        this.nInstrMethods = 0;
        this.nInstrClasses = 0;
        this.nInstantiatableClasses = 0;
    }

    protected abstract boolean methodNeedsInstrumentation(ClassInfo var1, int var2);

    protected Object[] createInstrumentedMethodPack() {
        if (this.nInstrMethods == 0) {
            return null;
        }
        return this.createInstrumentedMethodPack15();
    }

    protected boolean hasNewOpcodes(ClassInfo classInfo, int n, boolean bl) {
        this.msfno.setClassAndMethod(classInfo, n);
        return this.msfno.hasNewArrayOpcodes(this, bl);
    }

    protected abstract byte[] instrumentMethod(DynamicClassInfo var1, int var2);

    protected boolean methodNeedsRewriting(DynamicClassInfo dynamicClassInfo, int n) {
        return dynamicClassInfo.isMethodInstrumented(n);
    }

    int getNextClassId(String string) {
        if (this.nInstantiatableClasses == this.instantiatableClasses.length) {
            String[] stringArray = this.instantiatableClasses;
            this.instantiatableClasses = new String[stringArray.length + 100];
            System.arraycopy(stringArray, 0, this.instantiatableClasses, 0, stringArray.length);
        }
        this.instantiatableClasses[this.nInstantiatableClasses++] = string;
        this.status.updateAllocatedInstancesCountInfoInClient(string);
        return this.instrClassId++;
    }

    private Object[] createInstrumentedMethodPack15() {
        String[] stringArray = new String[this.nInstrClasses];
        int[] nArray = new int[this.nInstrClasses];
        byte[][] byArrayArray = new byte[this.nInstrClasses][];
        for (int i = 0; i < this.nInstrClasses; ++i) {
            DynamicClassInfo dynamicClassInfo = (DynamicClassInfo)this.instrClasses.get(i);
            stringArray[i] = dynamicClassInfo.getName().replace('/', '.');
            nArray[i] = dynamicClassInfo.getLoaderId();
            String[] stringArray2 = dynamicClassInfo.getMethodNames();
            int n = stringArray2.length;
            byte[][] byArrayArray2 = new byte[n][];
            DynamicConstantPoolExtension.getCPFragment(dynamicClassInfo, this.injType);
            for (int j = 0; j < n; ++j) {
                byArrayArray2[j] = this.methodNeedsRewriting(dynamicClassInfo, j) ? this.instrumentMethod(dynamicClassInfo, j) : dynamicClassInfo.getMethodInfo(j);
            }
            DynamicConstantPoolExtension dynamicConstantPoolExtension = DynamicConstantPoolExtension.getAllAddedCPFragments(dynamicClassInfo);
            int n2 = dynamicConstantPoolExtension.getNEntries();
            byte[] byArray = dynamicConstantPoolExtension.getContents();
            byArrayArray[i] = ClassRewriter.rewriteClassFile(dynamicClassInfo, byArrayArray2, n2, byArray);
        }
        return new Object[]{stringArray, nArray, byArrayArray};
    }

    static class MethodScanerForNewOpcodes
    extends SingleMethodScaner {
        MethodScanerForNewOpcodes() {
        }

        boolean hasNewArrayOpcodes(MemoryProfMethodInstrumentor memoryProfMethodInstrumentor, boolean bl) {
            int n = this.clazz.getLoaderId();
            boolean bl2 = false;
            for (int i = 0; i < this.bytecodesLength; i += this.opcodeLength(i)) {
                BaseClassInfo baseClassInfo;
                Object object;
                int n2;
                int n3 = this.bytecodes[i] & 0xFF;
                if (n3 == 187 && bl) {
                    bl2 = true;
                    n2 = this.getU2(i + 1);
                    object = this.clazz.getRefClassName(n2);
                    baseClassInfo = ClassManager.javaClassOrPlaceholderForName((String)object, n);
                    if (baseClassInfo.getInstrClassId() != -1) continue;
                    baseClassInfo.setInstrClassId(memoryProfMethodInstrumentor.getNextClassId(baseClassInfo.getName()));
                    continue;
                }
                if (n3 == 189 || n3 == 197) {
                    bl2 = true;
                    n2 = this.getU2(i + 1);
                    object = this.clazz.getRefClassName(n2);
                    BaseClassInfo baseClassInfo2 = baseClassInfo = n3 == 189 ? ClassManager.javaClassForObjectArrayType((String)object) : ClassRepository.lookupSpecialClass((String)object);
                    if (baseClassInfo == null || baseClassInfo.getInstrClassId() != -1) continue;
                    baseClassInfo.setInstrClassId(memoryProfMethodInstrumentor.getNextClassId(baseClassInfo.getName()));
                    continue;
                }
                if (n3 != 188) continue;
                bl2 = true;
                n2 = this.getByte(i + 1);
                object = ClassManager.javaClassForPrimitiveArrayType(n2);
                if (((BaseClassInfo)object).getInstrClassId() != -1) continue;
                ((BaseClassInfo)object).setInstrClassId(memoryProfMethodInstrumentor.getNextClassId(((BaseClassInfo)object).getName()));
            }
            return bl2;
        }
    }
}

