/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr.internal;

import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.rjmx.services.flr.IOptionConstraint;
import com.jrockit.mc.rjmx.services.flr.IOptionDescriptor;
import com.jrockit.mc.rjmx.services.flr.internal.ContentMashup;
import com.jrockit.mc.rjmx.services.flr.internal.ConversionToolkit;
import javax.management.openmbean.OpenType;

public class OptionMetadata<T extends Comparable<T>>
implements IOptionDescriptor,
IOptionConstraint<T> {
    private final String key;
    private final String description;
    private final String contentType;
    private final Class<T> type;
    private final OpenType<T> openType;
    private final T min;
    private final T max;
    private final T defaultValue;

    public OptionMetadata(String key, ContentMashup<T> contentMashup, String description, T min, T max, T defaultValue) {
        this.key = key;
        this.description = description;
        this.min = min;
        this.max = max;
        this.defaultValue = defaultValue;
        this.type = contentMashup.type;
        this.contentType = contentMashup.key;
        this.openType = contentMashup.openType;
    }

    public OptionMetadata(String key, Class<T> type, OpenType<T> openType, String description, T defaultValue) {
        this.key = key;
        this.description = description;
        this.min = null;
        this.max = null;
        this.defaultValue = defaultValue;
        this.type = type;
        this.contentType = null;
        this.openType = openType;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public IOptionConstraint<T> getConstraint() {
        return this;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public T getMin() {
        return this.min;
    }

    @Override
    public T getMax() {
        return this.max;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    OpenType<T> getOpenType() {
        return this.openType;
    }

    @Override
    public String toConfigString(T serverValue) {
        return ConversionToolkit.toConfigString(this, serverValue);
    }

    @Override
    public T toServerValue(String configurationValue) throws QuantityConversionException {
        return ConversionToolkit.toServerValue(this, configurationValue);
    }

    public String toString() {
        return String.valueOf(this.getKey()) + " [type=" + this.getType() + ", default=" + this.getDefaultValue() + ", description=" + this.getDescription() + ']';
    }
}

