/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr;

import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.rjmx.services.flr.IOptionConstraint;
import com.jrockit.mc.rjmx.services.flr.internal.ConversionToolkit;
import org.eclipse.osgi.util.NLS;

public final class RecordingOptionsValidator {
    private final Object value;
    private final IOptionConstraint<?> optionConstraint;
    private String errorMessage;

    public RecordingOptionsValidator(Object value, IOptionConstraint<?> optionConstraint) {
        if (optionConstraint == null) {
            throw new NullPointerException("Can not create validator with null option constraints!");
        }
        this.value = value;
        this.optionConstraint = optionConstraint;
    }

    public void validate() throws QuantityConversionException {
        if (this.value == null) {
            return;
        }
        this.validate(this.optionConstraint);
    }

    private <T extends Comparable<T>> void validate(IOptionConstraint<T> optionConstraint) throws QuantityConversionException {
        if (!optionConstraint.getType().isInstance(this.value)) {
            this.errorMessage = NLS.bind((String)"''{0}'' is not a valid value for {1}", (Object)this.value, (Object)optionConstraint.getContentType());
            throw new IllegalArgumentException(this.errorMessage);
        }
        Comparable typedValue = (Comparable)optionConstraint.getType().cast(this.value);
        ConversionToolkit.validateRange(optionConstraint, typedValue);
    }
}

