/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.BusyTabsSupport;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.TabPainter;

class MetalEditorTabCellRenderer
extends AbstractTabCellRenderer {
    private static final MetalTabPainter metalborder = new MetalTabPainter();
    private static final MetalRightClippedTabPainter rightBorder = new MetalRightClippedTabPainter();
    private static final MetalLeftClippedTabPainter leftBorder = new MetalLeftClippedTabPainter();
    static final Color ATTENTION_COLOR = new Color(255, 238, 120);

    public MetalEditorTabCellRenderer() {
        super(leftBorder, metalborder, rightBorder, new Dimension(34, 29));
        this.setBorder(metalborder);
    }

    @Override
    protected int getCaptionYAdjustment() {
        return 0;
    }

    @Override
    public Dimension getPadding() {
        Dimension dimension = super.getPadding();
        dimension.width = this.isShowCloseButton() && !Boolean.getBoolean("nb.tabs.suppressCloseButton") ? 34 : 24;
        return dimension;
    }

    @Override
    protected void paintIconAndText(Graphics graphics) {
        if (this.isBusy()) {
            this.setIcon(BusyTabsSupport.getDefault().getBusyIcon(this.isSelected()));
        }
        super.paintIconAndText(graphics);
    }

    private static class MetalRightClippedTabPainter
    implements TabPainter {
        private MetalRightClippedTabPainter() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            MetalEditorTabCellRenderer metalEditorTabCellRenderer = (MetalEditorTabCellRenderer)component;
            return new Insets(metalEditorTabCellRenderer.isSelected() ? 3 : 5, metalEditorTabCellRenderer.isSelected() ? 10 : 9, 1, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public Polygon getInteriorPolygon(Component component) {
            MetalEditorTabCellRenderer metalEditorTabCellRenderer = (MetalEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = metalEditorTabCellRenderer.isLeftmost() ? 1 : 0;
            int n2 = 0;
            int n3 = component.getWidth() + 2;
            int n4 = metalEditorTabCellRenderer.isSelected() ? component.getHeight() + 3 : component.getHeight();
            polygon.addPoint(n, n2 + insets.top + 6);
            polygon.addPoint(n + 6, n2 + insets.top);
            polygon.addPoint(n + n3, n2 + insets.top);
            polygon.addPoint(n + n3, n2 + n4);
            polygon.addPoint(n, n2 + n4);
            return polygon;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            MetalEditorTabCellRenderer metalEditorTabCellRenderer = (MetalEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(component);
            graphics.setColor(UIManager.getColor("controlHighlight"));
            graphics.drawPolygon(polygon);
            polygon.translate(-1, 0);
            Insets insets = this.getBorderInsets(component);
            graphics.drawLine(n + 6, n2 + insets.top + 1, n + n3 - 1, n2 + insets.top + 1);
            if (metalEditorTabCellRenderer.isSelected()) {
                graphics.drawLine(4, insets.top + 6, 4, insets.top + 6);
                graphics.drawLine(2, insets.top + 8, 2, insets.top + 8);
                graphics.drawLine(4, insets.top + 10, 4, insets.top + 10);
                graphics.drawLine(2, insets.top + 12, 2, insets.top + 12);
                graphics.drawLine(4, insets.top + 14, 4, insets.top + 14);
                graphics.drawLine(2, insets.top + 16, 2, insets.top + 16);
            }
            graphics.setColor(UIManager.getColor("controlDkShadow"));
            graphics.drawPolygon(polygon);
            if (metalEditorTabCellRenderer.isSelected()) {
                graphics.drawLine(5, insets.top + 7, 5, insets.top + 7);
                graphics.drawLine(3, insets.top + 9, 3, insets.top + 9);
                graphics.drawLine(5, insets.top + 11, 5, insets.top + 11);
                graphics.drawLine(3, insets.top + 13, 3, insets.top + 13);
                graphics.drawLine(5, insets.top + 15, 5, insets.top + 15);
                graphics.drawLine(3, insets.top + 17, 3, insets.top + 17);
            }
            if (!metalEditorTabCellRenderer.isSelected()) {
                graphics.setColor(UIManager.getColor("controlDkShadow"));
                graphics.drawLine(n, component.getHeight() - 1, component.getWidth() - 1, component.getHeight() - 1);
            }
        }

        @Override
        public void paintInterior(Graphics graphics, Component component) {
            Polygon polygon = this.getInteriorPolygon(component);
            MetalEditorTabCellRenderer metalEditorTabCellRenderer = (MetalEditorTabCellRenderer)component;
            if (metalEditorTabCellRenderer.isAttention()) {
                graphics.setColor(ATTENTION_COLOR);
            }
            graphics.fillPolygon(polygon);
        }

        @Override
        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            rectangle2.setBounds(-20, -20, 0, 0);
        }

        @Override
        public boolean supportsCloseButton(JComponent jComponent) {
            return false;
        }
    }

    private static class MetalLeftClippedTabPainter
    implements TabPainter {
        private MetalLeftClippedTabPainter() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            MetalEditorTabCellRenderer metalEditorTabCellRenderer = (MetalEditorTabCellRenderer)component;
            return new Insets(metalEditorTabCellRenderer.isSelected() ? 3 : 5, metalEditorTabCellRenderer.isSelected() ? 10 : 9, 1, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public Polygon getInteriorPolygon(Component component) {
            MetalEditorTabCellRenderer metalEditorTabCellRenderer = (MetalEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = -1;
            int n2 = insets.top;
            int n3 = component.getWidth();
            int n4 = metalEditorTabCellRenderer.isSelected() ? component.getHeight() + 3 : component.getHeight();
            polygon.addPoint(n, n2);
            polygon.addPoint(n + n3, n2);
            polygon.addPoint(n + n3, n2 + n4);
            polygon.addPoint(n, n2 + n4);
            return polygon;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            MetalEditorTabCellRenderer metalEditorTabCellRenderer = (MetalEditorTabCellRenderer)component;
            graphics.setColor(UIManager.getColor("controlHighlight"));
            Polygon polygon = this.getInteriorPolygon(component);
            polygon.translate(0, 1);
            graphics.drawPolygon(polygon);
            polygon.translate(0, -1);
            graphics.setColor(UIManager.getColor("controlDkShadow"));
            graphics.drawPolygon(polygon);
            if (!metalEditorTabCellRenderer.isSelected()) {
                graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
            }
        }

        @Override
        public void paintInterior(Graphics graphics, Component component) {
            Polygon polygon = this.getInteriorPolygon(component);
            MetalEditorTabCellRenderer metalEditorTabCellRenderer = (MetalEditorTabCellRenderer)component;
            if (metalEditorTabCellRenderer.isAttention()) {
                graphics.setColor(ATTENTION_COLOR);
            }
            graphics.fillPolygon(polygon);
        }

        @Override
        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            rectangle2.setBounds(-20, -20, 0, 0);
        }

        @Override
        public boolean supportsCloseButton(JComponent jComponent) {
            return false;
        }
    }

    private static class MetalTabPainter
    implements TabPainter {
        private MetalTabPainter() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            MetalEditorTabCellRenderer metalEditorTabCellRenderer = (MetalEditorTabCellRenderer)component;
            return new Insets(metalEditorTabCellRenderer.isSelected() ? 3 : 5, metalEditorTabCellRenderer.isSelected() ? 10 : 9, 1, 0);
        }

        @Override
        public boolean supportsCloseButton(JComponent jComponent) {
            return ((AbstractTabCellRenderer)jComponent).isShowCloseButton();
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            MetalEditorTabCellRenderer metalEditorTabCellRenderer = (MetalEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(component);
            graphics.setColor(UIManager.getColor("controlHighlight"));
            graphics.drawPolygon(polygon);
            polygon.translate(-1, 0);
            Insets insets = this.getBorderInsets(component);
            graphics.drawLine(n + 6, n2 + insets.top + 1, n + n3 - 1, n2 + insets.top + 1);
            if (metalEditorTabCellRenderer.isSelected()) {
                graphics.drawLine(4, insets.top + 6, 4, insets.top + 6);
                graphics.drawLine(2, insets.top + 8, 2, insets.top + 8);
                graphics.drawLine(4, insets.top + 10, 4, insets.top + 10);
                graphics.drawLine(2, insets.top + 12, 2, insets.top + 12);
                graphics.drawLine(4, insets.top + 14, 4, insets.top + 14);
                graphics.drawLine(2, insets.top + 16, 2, insets.top + 16);
            }
            graphics.setColor(UIManager.getColor("controlDkShadow"));
            graphics.drawPolygon(polygon);
            if (metalEditorTabCellRenderer.isSelected()) {
                graphics.drawLine(5, insets.top + 7, 5, insets.top + 7);
                graphics.drawLine(3, insets.top + 9, 3, insets.top + 9);
                graphics.drawLine(5, insets.top + 11, 5, insets.top + 11);
                graphics.drawLine(3, insets.top + 13, 3, insets.top + 13);
                graphics.drawLine(5, insets.top + 15, 5, insets.top + 15);
                graphics.drawLine(3, insets.top + 17, 3, insets.top + 17);
            }
            if (!metalEditorTabCellRenderer.isSelected()) {
                graphics.setColor(UIManager.getColor("controlDkShadow"));
                graphics.drawLine(n, metalEditorTabCellRenderer.getHeight() - 1, metalEditorTabCellRenderer.getWidth() - 1, metalEditorTabCellRenderer.getHeight() - 1);
            }
        }

        @Override
        public Polygon getInteriorPolygon(Component component) {
            MetalEditorTabCellRenderer metalEditorTabCellRenderer = (MetalEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = metalEditorTabCellRenderer.isLeftmost() ? 1 : 0;
            int n2 = 0;
            int n3 = metalEditorTabCellRenderer.isLeftmost() ? component.getWidth() - 1 : component.getWidth();
            int n4 = metalEditorTabCellRenderer.isSelected() ? component.getHeight() + 3 : component.getHeight();
            polygon.addPoint(n, n2 + insets.top + 6);
            polygon.addPoint(n + 6, n2 + insets.top);
            polygon.addPoint(n + n3, n2 + insets.top);
            polygon.addPoint(n + n3, n2 + n4);
            polygon.addPoint(n, n2 + n4);
            return polygon;
        }

        @Override
        public void paintInterior(Graphics graphics, Component component) {
            MetalEditorTabCellRenderer metalEditorTabCellRenderer = (MetalEditorTabCellRenderer)component;
            if (metalEditorTabCellRenderer.isAttention()) {
                graphics.setColor(ATTENTION_COLOR);
            }
            Polygon polygon = this.getInteriorPolygon(component);
            graphics.fillPolygon(polygon);
            Rectangle rectangle = new Rectangle();
            this.getCloseButtonRectangle(metalEditorTabCellRenderer, rectangle, new Rectangle(0, 0, metalEditorTabCellRenderer.getWidth(), metalEditorTabCellRenderer.getHeight()));
            if (!graphics.hitClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                return;
            }
            this.paintCloseButton(graphics, (JComponent)component);
        }

        @Override
        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            if (!((AbstractTabCellRenderer)jComponent).isShowCloseButton()) {
                rectangle.x = -100;
                rectangle.y = -100;
                rectangle.width = 0;
                rectangle.height = 0;
                return;
            }
            String string = this.findIconPath((MetalEditorTabCellRenderer)jComponent);
            Icon icon = TabControlButtonFactory.getIcon(string);
            int n = icon.getIconWidth();
            int n2 = icon.getIconHeight();
            rectangle.x = rectangle2.x + rectangle2.width - n - 2;
            rectangle.y = rectangle2.y + Math.max(0, rectangle2.height / 2 - n2 / 2) + 2;
            rectangle.width = n;
            rectangle.height = n2;
        }

        private void paintCloseButton(Graphics graphics, JComponent jComponent) {
            if (((AbstractTabCellRenderer)jComponent).isShowCloseButton()) {
                Rectangle rectangle = new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight());
                Rectangle rectangle2 = new Rectangle();
                this.getCloseButtonRectangle(jComponent, rectangle2, rectangle);
                String string = this.findIconPath((MetalEditorTabCellRenderer)jComponent);
                Icon icon = TabControlButtonFactory.getIcon(string);
                icon.paintIcon(jComponent, graphics, rectangle2.x, rectangle2.y);
            }
        }

        private String findIconPath(MetalEditorTabCellRenderer metalEditorTabCellRenderer) {
            if (metalEditorTabCellRenderer.inCloseButton() && metalEditorTabCellRenderer.isPressed()) {
                return "org/openide/awt/resources/metal_close_pressed.png";
            }
            if (metalEditorTabCellRenderer.inCloseButton()) {
                return "org/openide/awt/resources/metal_close_rollover.png";
            }
            return "org/openide/awt/resources/metal_close_enabled.png";
        }
    }
}

